function pi_models = build_lines(idx_from,idx_to,R_prime,X_prime,B_prime,l,Y_b)
% pi_models = build_lines(idx_from,idx_to,R_prime,X_prime,B_prime,l,Y_b)
% 
% INPUT
%   idx_from    Index of start bus.
%   idx_to      Index of end bus.
%   R_prime     Branch resistance in Ohm/km.
%   X_prime     Branch reactance in Ohm/km.
%   B_prime     Shunt susceptance in Siemens/km.
%   l           Length in km.
%   Y_b         Base admittance.
% 
% OUTPUT
%   pi_models   Per-unit pi-section equivalent circuits.

n_lines = length(idx_from);

pi_models = cell(n_lines,1);

for k=1:n_lines    
    pi_k = struct();
    
    % **********
    
    % !!! write your own code here !!!
    
    pi_k.i = idx_from(k);
    pi_k.j = idx_to(k);
    pi_k.Y_ij = 1 / ((R_prime(k) + 1i*X_prime(k)) * l(k)) / Y_b;
    pi_k.Y_i_ij = 1i/2 * B_prime(k) * l(k) / Y_b;
    pi_k.Y_j_ij = 1i/2 * B_prime(k) * l(k) / Y_b;
    
    % **********
    
    pi_models{k} = pi_k;
end

pi_models = [pi_models{:}];

end